##trichter=vector
##untersuchungsgebiet=vector
##area=number 250
##output=output vector

##trichter=vector
##untersuchungsgebiet=vector
##area=number 25
##output=output vector

library("mvtnorm")
library("misc3d")
library("rgl")
library("ks")
library("highriskzone")
library("spatstat")
library("sf")
spatstat.options(npixel=750)

trichter_dat = st_coordinates(trichter)
auswertegebiet_dat = st_coordinates(untersuchungsgebiet)

hrzdat <- try(read_pppdata(xppp=trichter_dat[,"X"],
                           yppp=trichter_dat[,"Y"],
                           xwin=(auswertegebiet_dat[,"X"]),
                           ywin=(auswertegebiet_dat[,"Y"])), silent = TRUE)
if (class(hrzdat) == "try-error") {
  hrzdat <- (read_pppdata(xppp=trichter_dat[,"X"],
                          yppp=trichter_dat[,"Y"],
                          xwin=rev(auswertegebiet_dat[,"X"]),
                          ywin=rev(auswertegebiet_dat[,"Y"])))
}
area_aus = area.owin(hrzdat$window)
if(area.owin(hrzdat$window)<area*10000)
  stop(paste0("untersuchungsgebiet ist kleiner als erwuenschte Flaeche der Risikozone (untersuchungsgebiet: ",
              round(area.owin(hrzdat$window)/10000,1), " ha; Erwuenscht: ",
              area," ha)"))

zone <- det_hrz(hrzdat, type = "dist", criterion = "area", cutoff = area*10000)

hrz <- zone$zone

hrz$m[is.na(hrz$m)] <- FALSE
output = st_as_sf(as.owin(hrz))


