##trichter=vector
##untersuchungsgebiet=vector
##radius=number 150
##output=output vector

if (radius < 0) {
stop("Radius um Bombenkrater (radius) muss fuer Berechnung der traditionellen Sicherheitszone groessÃÂÃÂer 0 gesetzt werden")
}

library("highriskzone")
library("spatstat")
library("sf")
spatstat.options(npixel=750)


trichter_dat = st_coordinates(trichter)
untersuchungsgebiet_dat = st_coordinates(untersuchungsgebiet)

hrzdat <- try(read_pppdata(xppp=trichter_dat[,"X"],
                           yppp=trichter_dat[,"Y"],
                           xwin=(untersuchungsgebiet_dat[,"X"]),
                           ywin=(untersuchungsgebiet_dat[,"Y"])), silent = TRUE)
if (class(hrzdat) == "try-error") {
  hrzdat <- (read_pppdata(xppp=trichter_dat[,"X"],
                          yppp=trichter_dat[,"Y"],
                          xwin=rev(untersuchungsgebiet_dat[,"X"]),
                          ywin=rev(untersuchungsgebiet_dat[,"Y"])))
}
zone.a <- det_hrz(hrzdat, type = "dist", criterion = "direct", cutoff = radius)

hrz <- zone.a$zone
hrz$m[is.na(hrz$m)] <- FALSE
output = st_as_sf(as.owin(hrz))

