##trichter=vector
##untersuchungsgebiet=vector
##blindgaengerwsk=number 0.15
##alpha=number 0.2
##output=output vector

if (blindgaengerwsk > 1 | blindgaengerwsk < 0) {
stop("Blindgaengerwahrscheinlichkeit muss zwischen 0 und 1 gesetzt werden")
}

if (alpha > 1 | alpha < 0) {
stop("alpha (globale Fehlerwahrscheinlichkeit) muss fuer intensitaetsbasierte high-risk zone zwischen 0 und 1 gesetzt werden")
}

library("highriskzone")
library("spatstat")
library("sf")
spatstat.options(npixel=750)


trichter_dat = st_coordinates(trichter)
untersuchungsgebiet_dat = st_coordinates(untersuchungsgebiet)

hrzdat <- try(read_pppdata(xppp=trichter_dat[,"X"],
                           yppp=trichter_dat[,"Y"],
                           xwin=(untersuchungsgebiet_dat[,"X"]),
                           ywin=(untersuchungsgebiet_dat[,"Y"])), silent = TRUE)
if (class(hrzdat) == "try-error") {
  hrzdat <- (read_pppdata(xppp=trichter_dat[,"X"],
                          yppp=trichter_dat[,"Y"],
                          xwin=rev(untersuchungsgebiet_dat[,"X"]),
                          ywin=rev(untersuchungsgebiet_dat[,"Y"])))
}

zone.a <- det_hrz(hrzdat, type = "intens", criterion = "indirect",
cutoff = alpha, nxprob = blindgaengerwsk)

hrz <- zone.a$zone
hrz$m[is.na(hrz$m)] <- FALSE
output = st_as_sf(as.owin(hrz))

