##trichter=vector
##untersuchungsgebiet=vector
##area=number 250
##output=output vector

if (area < 0) {
stop("area muss fuer intensitaetsbasierte high-risk zone >0 gesetzt werden")
}

library("highriskzone")
library("spatstat")
library("sf")
spatstat.options(npixel=2000)


trichter_dat = st_coordinates(trichter)
untersuchungsgebiet_dat = st_coordinates(untersuchungsgebiet)

hrzdat <- try(read_pppdata(xppp=trichter_dat[,"X"],
                           yppp=trichter_dat[,"Y"],
                           xwin=(untersuchungsgebiet_dat[,"X"]),
                           ywin=(untersuchungsgebiet_dat[,"Y"])), silent = TRUE)
if (class(hrzdat) == "try-error") {
  hrzdat <- (read_pppdata(xppp=trichter_dat[,"X"],
                          yppp=trichter_dat[,"Y"],
                          xwin=rev(untersuchungsgebiet_dat[,"X"]),
                          ywin=rev(untersuchungsgebiet_dat[,"Y"])))
}
if(area.owin(hrzdat$window)<area*10000)
  stop(paste0("Auswertegebiet ist kleiner als erwuenschte Flaeche der Risikozone (Auswertegebiet: ",
              round(area.owin(hrzdat$window)/10000,1), " ha; Erwuenscht: ",
              area," ha)"))
zone.a <- det_hrz(hrzdat, type = "intens", criterion = "area",
cutoff = area*10000)

hrz <- zone.a$zone

hrz$m[is.na(hrz$m)] <- FALSE
output = st_as_sf(as.owin(hrz))
