##trichter=vector
##untersuchungsgebiet=vector
##blindgaengerwsk=number 0.15
##threshold=number 1
##hole=vector
##output=output vector

if (blindgaengerwsk > 1 | blindgaengerwsk < 0) {
stop("Blindgaengerwahrscheinlichkeit muss zwischen 0 und 1 gesetzt werden")
}
if (threshold < 0) {
stop("threshold (Naximal erwartete Anzahl an Blindgaengern pro Quadratkilometer an einem punkt ausserhalb der Sicherheitszone) muss fuer intensitaetsbasierte high-risk zone > 0 gesetzt werden")
}

library("mvtnorm")
library("misc3d")
library("rgl")
library("ks")
library("highriskzone")
library("spatstat")
library("sf")
spatstat.options(npixel=750)


trichter_dat = st_coordinates(trichter)
untersuchungsgebiet_dat = st_coordinates(untersuchungsgebiet)

hrzdat <- try(read_pppdata(xppp=trichter_dat[,"X"],
                           yppp=trichter_dat[,"Y"],
                           xwin=(untersuchungsgebiet_dat[,"X"]),
                           ywin=(untersuchungsgebiet_dat[,"Y"])), silent = TRUE)
if (class(hrzdat) == "try-error") {
  hrzdat <- (read_pppdata(xppp=trichter_dat[,"X"],
                          yppp=trichter_dat[,"Y"],
                          xwin=rev(untersuchungsgebiet_dat[,"X"]),
                          ywin=rev(untersuchungsgebiet_dat[,"Y"])))
}
hole <- as.owin(hole)

zone.a <- det_hrz_restr(hrzdat, type = "intens", criterion = "direct",
cutoff = threshold*1e-6, hole = hole, nxprob = blindgaengerwsk)

hrz <- zone.a$zone

if(sum(hrz$m==1, na.rm = TRUE)==0) {
stop(paste("Kein Ort im Untersuchungsgebiet weisst eine hoehere erwartete Anzahl an Blindgaengern pro Quadratkilometer als", threshold,"auf."))
}

hrz$m[is.na(hrz$m)] <- FALSE
output = st_as_sf(as.owin(hrz))

