##trichter=vector
##auswertegebiet=vector
##untersuchungsgebiet=vector
##blindgaengerwsk=number 0.15
##alpha=number 0.2
##output=output vector

if (blindgaengerwsk > 1 | blindgaengerwsk < 0) {
stop("Blindgaengerwahrscheinlichkeit muss zwischen 0 und 1 gesetzt werden")
}

if (alpha > 1 | alpha < 0) {
stop("alpha (globale Fehlerwahrscheinlichkeit) muss fuer intensitaetsbasierte high-risk zone zwischen 0 und 1 gesetzt werden")
}


library("mvtnorm")
library("misc3d")
library("rgl")
library("ks")
library("highriskzone")
library("spatstat")
library("sf")
spatstat.options(npixel=750)

trichter_dat = st_coordinates(trichter)
auswertegebiet_dat = st_coordinates(auswertegebiet)

hrzdat <- try(read_pppdata(xppp=trichter_dat[,"X"],
                           yppp=trichter_dat[,"Y"],
                           xwin=(auswertegebiet_dat[,"X"]),
                           ywin=(auswertegebiet_dat[,"Y"])), silent = TRUE)
if (class(hrzdat) == "try-error") {
  hrzdat <- (read_pppdata(xppp=trichter_dat[,"X"],
                          yppp=trichter_dat[,"Y"],
                          xwin=rev(auswertegebiet_dat[,"X"]),
                          ywin=rev(auswertegebiet_dat[,"Y"])))
}

unters.owin = as.owin(untersuchungsgebiet)

zone.a <- det_hrz_eval_ar(hrzdat,
criterion = "indirect",
eval_ar = unters.owin,
cutoff = alpha,
nxprob = blindgaengerwsk)

hrz <- zone.a$zone
hrz$m[is.na(hrz$m)] <- FALSE

output = st_as_sf(as.owin(hrz))


