##trichter=vector
##untersuchungsgebiet=vector
##quantile=number 0.95
##output=output vector

if (quantile < 0 | quantile > 1) {
stop("quantile muss fuer quantile based sicherheitszone zone zwischen 0 und 1 gesetzt werden")
}


library("mvtnorm")
library("misc3d")
library("rgl")
library("ks")
library("highriskzone")
library("spatstat")
library("sf")
spatstat.options(npixel=750)


trichter_dat = st_coordinates(trichter)
untersuchungsgebiet_dat = st_coordinates(untersuchungsgebiet)

hrzdat <- try(read_pppdata(xppp=trichter_dat[,"X"],
                           yppp=trichter_dat[,"Y"],
                           xwin=(untersuchungsgebiet_dat[,"X"]),
                           ywin=(untersuchungsgebiet_dat[,"Y"])), silent = TRUE)
if (class(hrzdat) == "try-error") {
  hrzdat <- (read_pppdata(xppp=trichter_dat[,"X"],
                          yppp=trichter_dat[,"Y"],
                          xwin=rev(untersuchungsgebiet_dat[,"X"]),
                          ywin=rev(untersuchungsgebiet_dat[,"Y"])))
}

zone.a <- det_hrz(hrzdat, type = "dist", criterion = "indirect",
cutoff = quantile)

hrz <- zone.a$zone

hrz$m[is.na(hrz$m)] <- FALSE
output = st_as_sf(as.owin(hrz))
